package com.union_test.new_api.activity.expressad;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.speech.tts.TextToSpeech;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;

import androidx.annotation.Nullable;

import com.bytedance.sdk.openadsdk.api.banner.PAGBannerAd;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerAdInteractionListener;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerAdLoadListener;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerRequest;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerSize;
import com.union_test.internationad.R;
import com.union_test.new_api.RitConstants;
import com.union_test.new_api.utils.TToast;

public class PAGAnchoredAdaptiveBannerActivity extends Activity {
    private EditText anchored_width;
    private Button btn_banner_size;
    private FrameLayout anchored_container;
    private String TAG = "PAGAnchoredAdaptiveBannerActivity";
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED
                | WindowManager.LayoutParams.FLAG_TURN_SCREEN_ON);
        setContentView(R.layout.activity_anchored_banner);
        findViewById(R.id.btn_eb_back).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
        anchored_width = findViewById(R.id.anchored_width);
        btn_banner_size = findViewById(R.id.btn_banner_size);
        anchored_container = findViewById(R.id.anchored_container);
        btn_banner_size.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                loadAd();
            }
        });
    }

    private void loadAd() {
        anchored_container.removeAllViews();
        String anchoredWidth = anchored_width.getText().toString();
        if (TextUtils.isEmpty(anchoredWidth)) {
            TToast.show(PAGAnchoredAdaptiveBannerActivity.this, "anchored width is null");
            return;
        }
        int width;
        try {
            width = Integer.parseInt(anchoredWidth);
        } catch (Throwable e) {
            TToast.show(PAGAnchoredAdaptiveBannerActivity.this, "anchored width is not a number");
            return;
        }
        //step1:Create a PAGBannerSize
        PAGBannerSize bannerSize = PAGBannerSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize(this, width);
        //step2:Create a parameter PAGBannerRequest for banner ad request type,
        //      refer to the document for meanings of specific parameters
        PAGBannerRequest bannerRequest = new PAGBannerRequest(bannerSize);
        PAGBannerAd.loadAd(RitConstants.RIT_BANNER_320X50, bannerRequest, new PAGBannerAdLoadListener() {

            @Override
            public void onError(int code, String message) {
                TToast.show(PAGAnchoredAdaptiveBannerActivity.this, "load error : " + code + ", " + message);
                anchored_container.removeAllViews();
            }

            @Override
            public void onAdLoaded(PAGBannerAd pagBannerAd) {
                if (pagBannerAd == null) {
                    return;
                }
                Log.d(TAG,"anchored adsize width= "+pagBannerAd.getBannerSize().getWidth()+" , height= " +pagBannerAd.getBannerSize().getHeight());
                bindAdListener(pagBannerAd, PAGAnchoredAdaptiveBannerActivity.this);
                if (anchored_container != null) {
                    //step3:add ad view to view container
                    anchored_container.addView(pagBannerAd.getBannerView());
                }
                TToast.show(PAGAnchoredAdaptiveBannerActivity.this, "load success!");
            }
        });
    }

    private void bindAdListener(PAGBannerAd ad, Context mContext) {
        ad.setAdInteractionListener(new PAGBannerAdInteractionListener() {
            @Override
            public void onAdShowed() {
                TToast.show(mContext, "Ad showed");
            }

            @Override
            public void onAdClicked() {
                TToast.show(mContext, "Ad clicked");
            }

            @Override
            public void onAdDismissed() {
                TToast.show(mContext, "Ad dismissed");
            }
        });
    }
}
