package com.union_test.new_api.activity.expressad;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.WindowManager;

import androidx.annotation.IdRes;
import androidx.annotation.Nullable;

import com.union_test.internationad.R;

public class PAGBannerActivity extends Activity {
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED
                | WindowManager.LayoutParams.FLAG_TURN_SCREEN_ON);
        setContentView(R.layout.activity_banner);
        findViewById(R.id.btn_eb_back).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
        bindButton(R.id.btn_fixed_banner,PAGFixBannerActivity.class);
        bindButton(R.id.btn_anchored_banner,PAGAnchoredAdaptiveBannerActivity.class);
        bindButton(R.id.btn_inline_banner,PAGInlineAdaptiveBannerActivity.class);
    }

    private void bindButton(@IdRes int id, final Class clz) {
        findViewById(id).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(PAGBannerActivity.this, clz);
                startActivity(intent);
            }
        });
    }
}
