package com.union_test.new_api.activity.expressad;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;

import androidx.annotation.Nullable;

import com.bytedance.sdk.openadsdk.api.banner.PAGBannerAd;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerAdInteractionListener;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerAdLoadListener;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerRequest;
import com.bytedance.sdk.openadsdk.api.banner.PAGBannerSize;
import com.union_test.internationad.R;
import com.union_test.new_api.RitConstants;
import com.union_test.new_api.utils.TToast;

public class PAGInlineAdaptiveBannerActivity extends Activity {
    private EditText inline_width_one;
    private Button load_by_default_maxheight;
    private EditText inline_width_two;
    private EditText inline_custom_maxheight;
    private Button load_by_custom_height;
    private FrameLayout inline_container;
    private String TAG = "PAGInlineAdaptiveBannerActivity";
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED
                | WindowManager.LayoutParams.FLAG_TURN_SCREEN_ON);
        setContentView(R.layout.activity_inline_banner);
        findViewById(R.id.btn_eb_back).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
        inline_width_one = findViewById(R.id.inline_width_one);
        load_by_default_maxheight = findViewById(R.id.load_by_default_maxheight);
        inline_width_two = findViewById(R.id.inline_width_two);
        inline_custom_maxheight = findViewById(R.id.inline_custom_maxheight);
        load_by_custom_height = findViewById(R.id.load_by_custom_height);
        inline_container = findViewById(R.id.inline_container);

        load_by_default_maxheight.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                loadAdDefaultMaxHeight();
            }
        });
        load_by_custom_height.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                loadAdCustomMaxHeight();
            }
        });
    }

    private void loadAdDefaultMaxHeight() {
        inline_container.removeAllViews();
        String inlineWidthOne = inline_width_one.getText().toString();
        if (TextUtils.isEmpty(inlineWidthOne)) {
            TToast.show(PAGInlineAdaptiveBannerActivity.this, "inline width is null");
            return;
        }
        int width;
        try {
            width = Integer.parseInt(inlineWidthOne);
        } catch (Throwable e) {
            TToast.show(PAGInlineAdaptiveBannerActivity.this, "inline width is not a number");
            return;
        }
        //step1:Create a PAGBannerSize
        PAGBannerSize bannerSize = PAGBannerSize.getCurrentOrientationInlineAdaptiveBannerAdSize(this, width);
        //step2:Create a parameter PAGBannerRequest for banner ad request type,
        //      refer to the document for meanings of specific parameters
        PAGBannerRequest bannerRequest = new PAGBannerRequest(bannerSize);
        PAGBannerAd.loadAd(RitConstants.RIT_BANNER_300X250, bannerRequest, new PAGBannerAdLoadListener() {

            @Override
            public void onError(int code, String message) {
                TToast.show(PAGInlineAdaptiveBannerActivity.this, "load error : " + code + ", " + message);
                inline_container.removeAllViews();
            }

            @Override
            public void onAdLoaded(PAGBannerAd pagBannerAd) {
                if (pagBannerAd == null) {
                    return;
                }
                Log.d(TAG,"inline adsize width= "+pagBannerAd.getBannerSize().getWidth()+" , height= " +pagBannerAd.getBannerSize().getHeight());
                bindAdListener(pagBannerAd, PAGInlineAdaptiveBannerActivity.this);
                if (inline_container != null) {
                    //step3:add ad view to view container
                    inline_container.addView(pagBannerAd.getBannerView());
                }
                TToast.show(PAGInlineAdaptiveBannerActivity.this, "load success!");
            }
        });
    }

    private void loadAdCustomMaxHeight() {
        inline_container.removeAllViews();
        String inlineWidthTwo = inline_width_two.getText().toString();
        String inlineCustomMaxHeight = inline_custom_maxheight.getText().toString();
        if (TextUtils.isEmpty(inlineWidthTwo) || TextUtils.isEmpty(inlineCustomMaxHeight)) {
            TToast.show(PAGInlineAdaptiveBannerActivity.this, "inline width or maxHeight is null");
            return;
        }
        int width;
        int maxHeight;
        try {
            width = Integer.parseInt(inlineWidthTwo);
            maxHeight = Integer.parseInt(inlineCustomMaxHeight);
        } catch (Throwable e) {
            TToast.show(PAGInlineAdaptiveBannerActivity.this, "inline width or maxHeight is not a number");
            return;
        }
        //step1:Create a PAGBannerSize
        PAGBannerSize bannerSize = PAGBannerSize.getInlineAdaptiveBannerAdSize(width,maxHeight);
        //step2:Create a parameter PAGBannerRequest for banner ad request type,
        //      refer to the document for meanings of specific parameters
        PAGBannerRequest bannerRequest = new PAGBannerRequest(bannerSize);
        PAGBannerAd.loadAd(RitConstants.RIT_BANNER_300X250, bannerRequest, new PAGBannerAdLoadListener() {

            @Override
            public void onError(int code, String message) {
                TToast.show(PAGInlineAdaptiveBannerActivity.this, "load error : " + code + ", " + message);
                inline_container.removeAllViews();
            }

            @Override
            public void onAdLoaded(PAGBannerAd pagBannerAd) {
                if (pagBannerAd == null) {
                    return;
                }
                Log.d(TAG,"inline adsize width= "+pagBannerAd.getBannerSize().getWidth()+" , height= " +pagBannerAd.getBannerSize().getHeight());
                bindAdListener(pagBannerAd, PAGInlineAdaptiveBannerActivity.this);
                if (inline_container != null) {
                    //step3:add ad view to view container
                    inline_container.addView(pagBannerAd.getBannerView());
                }
                TToast.show(PAGInlineAdaptiveBannerActivity.this, "load success!");
            }
        });
    }

    private void bindAdListener(PAGBannerAd ad, Context mContext) {
        ad.setAdInteractionListener(new PAGBannerAdInteractionListener() {
            @Override
            public void onAdShowed() {
                TToast.show(mContext, "Ad showed");
            }

            @Override
            public void onAdClicked() {
                TToast.show(mContext, "Ad clicked");
            }

            @Override
            public void onAdDismissed() {
                TToast.show(mContext, "Ad dismissed");
            }
        });
    }
}
