package com.union_test.new_api.sp;

import android.content.Context;
import android.content.SharedPreferences;

import com.union_test.new_api.DemoApplication;


public class PangleSpUtils {


    private static final String TAG = "PangleSpUtils";


    private static final String KEY_GDPR = "pangle_gdpr";

    public static final String PANGLE_DEMO_SP = "pangle_demo_sp";


    private static volatile PangleSpUtils mUserManager;
    private final SharedPreferences sp;

    private PangleSpUtils() {
        sp = DemoApplication.CONTEXT.getSharedPreferences(PANGLE_DEMO_SP, Context.MODE_PRIVATE);
    }



    public static PangleSpUtils getInstance() {
        if (mUserManager == null) {
            synchronized (PangleSpUtils.class) {
                if (mUserManager == null) {
                    mUserManager = new PangleSpUtils();
                }
            }
        }
        return mUserManager;
    }



    public void setGdpr(int gdpr) {
        SharedPreferences.Editor editor = sp.edit();
        editor.putInt(KEY_GDPR, gdpr);
        editor.apply();
    }

    public int getGdpr() {
        return sp.getInt(KEY_GDPR, 1);
    }




}
