//
//  BUDInlineAdaptiveViewController.m
//  BUDemo
//
//  Created by yy on 11/4/24.
//  Copyright © 2024 bytedance. All rights reserved.
//

#import "BUDInlineAdaptiveViewController.h"
#import "BUDListItem.h"
#import "BUDListAdItem.h"
#import "BUDMacros.h"
#import "BUDSlotID.h"
#import "BUDInlineAdaptiveAdCell.h"

@interface BUDInlineAdaptiveViewController ()<UITableViewDataSource,PAGBannerAdDelegate,UITableViewDelegate>

@property (nonatomic, strong) UITableView *tableView;
@property (nonatomic, assign) NSInteger adInterval;
@property (nonatomic, strong) NSMutableArray *items;
@property (nonatomic, strong) NSMutableArray *adsToLoad;
@property (nonatomic, strong) PAGBannerAd *bannerAd;

@end

@implementation BUDInlineAdaptiveViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = [UIColor whiteColor];
    
    self.items = [NSMutableArray array];
    self.adsToLoad = [NSMutableArray array];
    
    self.adInterval = 2 * CGRectGetWidth(self.view.frame) / 402;
    
    self.tableView = [[UITableView alloc] initWithFrame:self.view.bounds style:UITableViewStyleGrouped];
    self.tableView.contentInset = UIEdgeInsetsMake(0, 0, 100, 0);
    [self.view addSubview:self.tableView];
    self.tableView.dataSource = self;
    self.tableView.delegate = self;
    
    [self _addItems];
}

- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
    [self _loadBannerAd];
}

// MARK: - banner ad

- (void)_loadBannerAd {
    if (self.adsToLoad.count == 0) {
        return;
    }
    BUDListAdItem *adItem = self.adsToLoad.firstObject;
    [self.adsToLoad removeObject:adItem];
    PAGBannerAdSize size = PAGCurrentOrientationInlineAdaptiveBannerAdSizeWithWidth(CGRectGetWidth(self.view.frame) - self.view.safeAreaInsets.left - self.view.safeAreaInsets.right);
    PAGBannerRequest *r = [PAGBannerRequest requestWithBannerSize:size];
    [PAGBannerAd loadAdWithSlotID:@"980099802"
                          request:r
                completionHandler:^(PAGBannerAd * _Nullable bannerAd, NSError * _Nullable error) {
        if (error) {
            [self _logWithSEL:@selector(_loadBannerAd) msg:[NSString stringWithFormat:@"banner ad load fail : %@",error]];
            return;
        }
        
        [self _logWithSEL:_cmd msg:[NSString stringWithFormat:@"banner ad load success : %@",@(bannerAd.adSize.size)]];
        
        adItem.bannerAd = bannerAd;
        adItem.bannerAd.delegate = self;
        adItem.bannerAd.rootViewController = self;
        [self.tableView reloadData];
        //Load next banner ad.
        [self _loadBannerAd];
    }];
    
}

// MARK: - PAGBannerAdDelegate

- (void)adDidShow:(PAGBannerAd *)ad {

    [self _logWithSEL:_cmd msg:nil];
}

- (void)adDidClick:(PAGBannerAd *)ad {

    [self _logWithSEL:_cmd msg:nil];
}

- (void)adDidDismiss:(PAGBannerAd *)ad {
    
    [self _logWithSEL:_cmd msg:nil];
}

// MARK: - UITableViewDataSource & UITableViewDelegate
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.items.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    if ([self.items[indexPath.row] isKindOfClass:[BUDListAdItem class]]) {
        NSString *cellId = @"adCell";
        BUDInlineAdaptiveAdCell *adCell = [tableView dequeueReusableCellWithIdentifier:cellId];
        if (!adCell) {
            adCell = [[BUDInlineAdaptiveAdCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:cellId];
        }
        
        BUDListAdItem *adItem = self.items[indexPath.row];
        [adCell updateAd:adItem.bannerAd];
        return adCell;
    }
    
    NSString *cellId = @"contentCell";
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:cellId];
    if (!cell) {
        cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleSubtitle reuseIdentifier:cellId];
        cell.detailTextLabel.numberOfLines = 0;
    }
    BUDListItem *item = self.items[indexPath.row];
    cell.textLabel.text = item.title;
    cell.detailTextLabel.text = item.detail;
    return cell;
}

- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    if ([self.items[indexPath.row] isKindOfClass:[BUDListAdItem class]]) {
        BUDListAdItem *adItem = self.items[indexPath.row];
        return adItem.bannerAd ? adItem.bannerAd.adSize.size.height : 0;
    }
    return UITableViewAutomaticDimension;
}

- (void)_addItems {
    NSError *error = nil;
    NSString *JSONPath = [[NSBundle mainBundle] pathForResource:@"InlineAdaptiveBannerDemoJosn" ofType:@"json"];
    NSData *JSONData = [NSData dataWithContentsOfFile:JSONPath options:0 error:&error];
    if (error) {
        NSLog(@"Failed to parse JSON file containing menu item data with error: %@", error);
        return;
    }
    NSArray *JSONArray = [NSJSONSerialization JSONObjectWithData:JSONData options:0 error:&error];
    if (error) {
        NSLog(@"Failed to load menu item JSON data with error: %@", error);
        return;
    }
    
    // Create custom objects from JSON array.
    NSInteger i = 1;
    for (NSDictionary *dict in JSONArray) {
        BUDListItem *item = [[BUDListItem alloc] initWithDictionary:dict];
        [self.items addObject:item];
        
        // Add ad Item
        if (i == self.adInterval) {
            BUDListAdItem *adItem = [BUDListAdItem new];
            [self.items addObject:adItem];
            [self.adsToLoad addObject:adItem];
            i = 1;
        }
        else {
            i++;
        }
    }
}

- (void)_logWithSEL:(SEL)sel msg:(NSString *)msg {
    BUD_Log(@"BUDInlineAdaptiveViewController | %@ | %@",NSStringFromSelector(sel), msg);
}

@end
