//
//  BUDMacros.m
//  BUDemo
//
//  Created by bytedance on 2024/7/25.
//  Copyright © 2024 bytedance. All rights reserved.
//

#import "BUDMacros.h"

UIEdgeInsets BUDSafeAreaInsets(void) {
    static UIEdgeInsets _PAGSafeAreaInsetsValue;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        if (@available(iOS 11.0, *)) {
            _PAGSafeAreaInsetsValue = [UIApplication sharedApplication].windows.firstObject.safeAreaInsets;
        } else {
            _PAGSafeAreaInsetsValue = UIEdgeInsetsZero;
        }
    });
    return  _PAGSafeAreaInsetsValue;
}

BOOL bud_is_notch_screen(void) {
    static BOOL _is_notch_screen;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        UIEdgeInsets insets = BUDSafeAreaInsets();
        UIInterfaceOrientation orientation = [UIApplication sharedApplication].statusBarOrientation;
        if (orientation != UIInterfaceOrientationLandscapeLeft && orientation != UIInterfaceOrientationLandscapeRight) {
            /* 竖屏
             * iPhone 12    {47, 0, 34, 0}
             * iPhone X     {44, 0, 34, 0}
             * iPhone 8     {20, 0, 0, 0}
             */
            _is_notch_screen = insets.top > 20;
        } else {
            /* 横屏
             * iPhone 12    {0, 47, 21, 47}
             * iPhone X     {0, 44, 21, 44}
             * iPhone 8     {0, 0, 0, 0}
             */
            _is_notch_screen = insets.left > 20;
        }
    });
    return _is_notch_screen;
}
