//
//  BUADVADemo
//
//  Created by bytedance in 2022.
//  Copyright © 2022 bytedance. All rights reserved.

#import "BUDSanWebViewController.h"
#import <WebKit/WebKit.h>

static NSString *const BUDJSBridgeCommonName = @"callMethodParams";

@interface BUDSanWebViewController () <WKScriptMessageHandler>

@property(nonatomic, strong) WKWebView *webView;
@property(nonatomic, copy) NSString *urlString;

@end

@implementation BUDSanWebViewController

- (instancetype)initWithURLString:(NSString *)urlString {
  if (self = [super init]) {
    self.urlString = urlString;
  }
  return self;
}

+ (instancetype)openURLString:(NSString *)urlString {
  return [[BUDSanWebViewController alloc] initWithURLString:urlString];
}

- (void)viewDidLoad {
    [super viewDidLoad];

    //  https://s3a.bytecdn.cn/ies/bridge/bytedance/test/index.html#/

    self.title = self.urlString;

    self.navigationItem.leftBarButtonItem = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemCancel target:self action:@selector(cancel:)];

    WKUserContentController *userContentController = [[WKUserContentController alloc] init];
    [userContentController addScriptMessageHandler:self name:BUDJSBridgeCommonName];

    WKWebViewConfiguration *configuration = [[WKWebViewConfiguration alloc] init];
    configuration.userContentController = userContentController;
    
    self.webView = [[WKWebView alloc] initWithFrame:self.view.bounds configuration:configuration];
    self.webView.autoresizingMask = UIViewAutoresizingFlexibleWidth|UIViewAutoresizingFlexibleHeight;
    
    [self.view addSubview:self.webView];

    if (self.urlString) {
    [self.webView loadRequest:[NSURLRequest requestWithURL:[NSURL URLWithString:self.urlString]]];
    }
}

- (void)userContentController:(WKUserContentController *)userContentController didReceiveScriptMessage:(WKScriptMessage *)message{
    if ([message.name isEqualToString:BUDJSBridgeCommonName]) {
        if (message.body) {
            NSDictionary *bodyDic = message.body;
            NSString *func = bodyDic[@"func"];
            if ([func isEqualToString:@"app.StartPitayaSession"]) {
                NSMutableDictionary *dict1 = [NSMutableDictionary dictionary];
                dict1[@"__msg_type"] = @"event";
                dict1[@"__event_id"] = @"app.PitayaSessionState";
                dict1[@"__params"] = @{@"state":@"connecting"};
                NSData *jsonData = [NSJSONSerialization dataWithJSONObject:dict1 options:0 error:0];
                NSString *callbackParametersString = [[NSString alloc] initWithData:jsonData encoding:NSUTF8StringEncoding];
                NSString *jsString = [NSString stringWithFormat:@"window.ToutiaoJSBridge._handleMessageFromToutiao(%@);", callbackParametersString];
                
                [self->_webView evaluateJavaScript:jsString completionHandler:^(id _Nullable responseBody, NSError * _Nullable error) {
                    
                }];
            }
        }
    }
}

- (void)cancel:(id)sender {
  [self dismissViewControllerAnimated:YES completion:^{
  }];
}

@end
