//
//  BUDAnchoredBannerViewController.m
//  BUDemo
//
//  Created by yy on 11/4/24.
//  Copyright © 2024 bytedance. All rights reserved.
//

#import "BUDAnchoredBannerViewController.h"
#import "BUDSwitchView.h"
#import "UIColor+DarkMode.h"
#import "BUDSelectedView.h"
#import <PAGAdSDK/PAGAdSDK.h>
#import "BUDMacros.h"
#import "BUDSlotID.h"


@interface BUDAnchoredBannerViewController ()<PAGBannerAdDelegate>

@property (nonatomic, copy)   NSArray *titlesAndIDS;
@property (nonatomic, copy)   NSDictionary *sizeDcit;
@property (nonatomic, strong) UIView *bannerView;
@property (nonatomic, strong) BUDSelectedView *selectedView;
@property (nonatomic, strong) BUDSwitchView *slotSwitchView;
@property (nonatomic, strong) PAGBannerAd *bannerAd;

@end

@implementation BUDAnchoredBannerViewController

- (void)dealloc {
    [self _logWithSEL:_cmd msg:nil];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    BUDSelcetedItem *item2 = [[BUDSelcetedItem alloc] initWithDict:@{@"slotID":express_banner_ID_640100,@"title":@"Anchored Banner"}];
    self.titlesAndIDS = @[@[item2]];
    
    [self _setupUI];
}

// MARK: - Private

/// Set up demo interface
- (void)_setupUI {
    
    self.view.backgroundColor = UIColor.bud_systemBackgroundColor;
    
    __weak typeof(self) weakself = self;
    self.selectedView = [[BUDSelectedView alloc] initWithAdName:self.adName SelectedTitlesAndIDS:self.titlesAndIDS loadAdAction:^(NSString * _Nullable slotId) {
        __strong typeof(self) strongself = weakself;
        [strongself _loadBannerWithSlotID:slotId];
    } showAdAction:^{
        __strong typeof(self) strongself = weakself;
        [strongself _showBanner];
    }];
    self.selectedView.promptStatus = BUDPromptStatusDefault;
    [self.view addSubview:self.selectedView];
}

- (void)viewWillTransitionToSize:(CGSize)size
    withTransitionCoordinator:(id)coordinator {
  [super viewWillTransitionToSize:size withTransitionCoordinator:coordinator];

  [coordinator animateAlongsideTransition:nil
      completion:^(id _Nonnull context) {
    [self _loadBannerWithSlotID:express_banner_ID_640100];
  }];
}

- (void)_loadBannerWithSlotID:(NSString *)slotID {
    
    self.selectedView.promptStatus = BUDPromptStatusLoading;
    
    [self.bannerView removeFromSuperview];
    UIWindow *window = nil;
    if ([[UIApplication sharedApplication].delegate respondsToSelector:@selector(window)]) {
        window = [[UIApplication sharedApplication].delegate window];
    }
    if (![window isKindOfClass:[UIView class]]) {
        window = [UIApplication sharedApplication].keyWindow;
    }
    if (!window) {
        window = [[UIApplication sharedApplication].windows objectAtIndex:0];
    }
    CGFloat bottom = 0.0;
    if (@available(iOS 11.0, *)) {
        bottom = window.safeAreaInsets.bottom;
    } else {
        // Fallback on earlier versions
    }

    PAGBannerAdSize size = PAGCurrentOrientationAnchoredAdaptiveBannerAdSizeWithWidth(CGRectGetWidth(self.view.frame));
    [PAGBannerAd loadAdWithSlotID:slotID
                          request:[PAGBannerRequest requestWithBannerSize:size]
                completionHandler:^(PAGBannerAd * _Nullable bannerAd, NSError * _Nullable error) {
        if (error) {
            self.selectedView.promptStatus = BUDPromptStatusAdLoadedFail;
            [self _logWithSEL:@selector(_loadBannerWithSlotID:) msg:[NSString stringWithFormat:@"banner ad load fail : %@",error]];
            return;
        }
        self.selectedView.promptStatus = BUDPromptStatusAdLoaded;

        self.bannerAd = bannerAd;
        // 不支持中途更改代理，中途更改代理会导致接收不到广告相关回调，如若存在中途更改代理场景，需自行处理相关逻辑，确保广告相关回调正常执行。
        self.bannerAd.delegate = self;
        self.bannerAd.rootViewController = self;
        self.bannerView = self.bannerAd.bannerView;
        CGSize size = bannerAd.adSize.size;
        self.bannerView.frame = CGRectMake((self.view.width-size.width)/2.0, self.view.height-size.height-bottom, size.width, size.height);
    }];
}

- (void)_showBanner {
    
    self.selectedView.promptStatus = BUDPromptStatusDefault;

    [self.view addSubview:self.bannerView];
}

- (void)_logWithSEL:(SEL)sel msg:(NSString *)msg {
    BUD_Log(@"BUDAnchoredBannerViewController | %@ | %@",NSStringFromSelector(sel), msg);
}

# pragma mark - PAGBannerAdDelegate

- (void)adDidShow:(id<PAGAdProtocol>)ad {
    
    [self _logWithSEL:_cmd msg:nil];
}

- (void)adDidClick:(id<PAGAdProtocol>)ad {

    [self _logWithSEL:_cmd msg:nil];
}

- (void)adDidDismiss:(id<PAGAdProtocol>)ad {
    
    [self _logWithSEL:_cmd msg:nil];
}


@end
