//
//  BUDBannerTypeViewController.m
//  BUDemo
//
//  Created by yy on 11/4/24.
//  Copyright © 2024 bytedance. All rights reserved.
//

#import "BUDBannerTypeViewController.h"
#import "BUDActionCellDefine.h"
#import "BUDActionCellView.h"
#import "BUDBannerViewController.h"
#import "BUDAnchoredBannerViewController.h"
#import "BUDInlineAdaptiveViewController.h"

@interface BUDBannerTypeViewController ()<UITableViewDataSource,UITableViewDelegate>

@property (nonatomic, strong) UITableView *tableView;

@property (nonatomic, strong) NSArray *items;

@end

@implementation BUDBannerTypeViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    self.view.backgroundColor = [UIColor whiteColor];
    // Do any additional setup after loading the view.
    self.tableView = [[UITableView alloc] initWithFrame:self.view.bounds style:UITableViewStyleGrouped];
    self.tableView.contentInset = UIEdgeInsetsMake(0, 0, 100, 0);
    [self.view addSubview:self.tableView];
    self.tableView.dataSource = self;
    self.tableView.delegate = self;
    
    Class plainActionCellClass = [BUDActionCellView class];
    [self.tableView registerClass:plainActionCellClass forCellReuseIdentifier:NSStringFromClass(plainActionCellClass)];

    __weak typeof(self) weakSelf = self;
    BUDActionModel *standardBanner = [BUDActionModel plainTitleActionModel:@"Standard Banner" type:BUDCellType_native action:^{
        __strong typeof(weakSelf) self = weakSelf;
        [self showViewController:[[BUDBannerViewController alloc] init] sender:nil];
    }];
    BUDActionModel *AnchoredBanner = [BUDActionModel plainTitleActionModel:@"Anchored Banner" type:BUDCellType_native action:^{
        __strong typeof(weakSelf) self = weakSelf;
        [self showViewController:[[BUDAnchoredBannerViewController alloc] init] sender:nil];
    }];
    BUDActionModel *AdaptiveBanner = [BUDActionModel plainTitleActionModel:@"Inline Adaptive Banner" type:BUDCellType_native action:^{
        __strong typeof(weakSelf) self = weakSelf;
        [self showViewController:[[BUDInlineAdaptiveViewController alloc] init] sender:nil];
    }];
    
    self.items = @[
        standardBanner,
        AnchoredBanner,
        AdaptiveBanner
    ];
    
    [self.tableView reloadData];
}

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.items.count;
}

- (CGFloat)tableView:(UITableView *)tableView heightForHeaderInSection:(NSInteger)section {
    return 22;
}

-(CGFloat)tableView:(UITableView *)tableView heightForFooterInSection:(NSInteger)section {
    return 0.01;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    BUDActionModel *model = self.items[indexPath.row];
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"BUDActionCellView" forIndexPath:indexPath];
    if ([cell conformsToProtocol:@protocol(BUDActionCellConfig)]) {
        [(id<BUDActionCellConfig>)cell configWithModel:model];
    } else {
        cell = [UITableViewCell new];
    }
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    UITableViewCell<BUDCommandProtocol> *cell = [tableView cellForRowAtIndexPath:indexPath];
    if ([cell conformsToProtocol:@protocol(BUDCommandProtocol)]) {
        [cell execute];
    }
}

@end
