//
//  BUDInlineAdaptiveAdCell.m
//  BUDemo
//
//  Created by yy on 1/7/25.
//  Copyright © 2025 bytedance. All rights reserved.
//

#import "BUDInlineAdaptiveAdCell.h"

@interface BUDInlineAdaptiveAdCell ()

@property (nonatomic, strong) PAGBannerAd *bannerAd;

@end

@implementation BUDInlineAdaptiveAdCell

- (instancetype)initWithStyle:(UITableViewCellStyle)style reuseIdentifier:(NSString *)reuseIdentifier {
    self = [super initWithStyle:style reuseIdentifier:reuseIdentifier];
    if (self) {
        
    }
    return self;
}

- (void)layoutSubviews {
    [super layoutSubviews];
    if (self.bannerAd) {
        CGSize size = self.bannerAd.adSize.size;
        CGRect frame = CGRectMake((CGRectGetWidth(self.contentView.frame) - size.width) * 0.5,
                                  (CGRectGetHeight(self.contentView.frame) - size.height) * 0.5,
                                  size.width,
                                  size.height);
        self.bannerAd.bannerView.frame = frame;
    }
    
}

- (void)updateAd:(PAGBannerAd *)ad {
    //update ad view
    [self.bannerAd.bannerView removeFromSuperview];
    
    self.bannerAd = ad;
    [self.contentView addSubview:self.bannerAd.bannerView];
}

@end
